'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Gebuehren_Click()
    FormularBereich = "Gebuehren"
    Me.Termine.Visible = False
    Me.Termine_geloescht.Visible = False
    Me.Kalender.Visible = False
    Me.Gebuehren.Visible = True
    Me.Rechnungen.Visible = False
    Me.Jahresauswahl.Enabled = False
    Me.Haken_Kalender.Enabled = False
    Me.Haken_geloeschte_Termine.Enabled = False
    Me.Button_Termine.FontWeight = 400
    Me.Button_Rechnungen.FontWeight = 400
    Me.Button_Gebuehren.FontWeight = 700
    
    Me.Button_Tabellenansicht.Enabled = False
    
    'Preisliste auf akt. Kunden einstellen
    Call PreiseNachKategorieFiltern
    
End Sub

Private Sub Button_Rechnungen_Click()
    FormularBereich = "Rechnungen"
    Me.Termine.Visible = False
    Me.Termine_geloescht.Visible = False
    Me.Kalender.Visible = False
    Me.Gebuehren.Visible = False
    Me.Rechnungen.Visible = True
    Me.Jahresauswahl.Enabled = True
    Me.Haken_Kalender.Enabled = False
    Me.Haken_geloeschte_Termine.Enabled = False
    Me.Button_Termine.FontWeight = 400
    Me.Button_Rechnungen.FontWeight = 700
    Me.Button_Gebuehren.FontWeight = 400
    
    Me.Button_Tabellenansicht.Enabled = False
    
    Me.Hinweis_Preistabelle.Visible = False
End Sub

Private Sub Button_Rechnungsbuch_oeffnen_Click()
On Error GoTo Err_Button_Rechnungsbuch_oeffnen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Prfen, ob Rechnungstabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Rechnungen")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Rechnungen generiert.", vbInformation, "Hinweis"
        Exit Sub
    End If
    rst.Close
    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Rechnungsbuch ffnen
    FormularName = "Rechnungen_Uebersicht"
    
    DoCmd.Close acForm, FormularName, acSaveYes
    DoCmd.OpenForm FormularName, , , , , , AktRechnung
    
    
Exit_Button_Rechnungsbuch_oeffnen_Click:
    Exit Sub

Err_Button_Rechnungsbuch_oeffnen_Click:
    MsgBox err.Description
    Resume Exit_Button_Rechnungsbuch_oeffnen_Click
    
End Sub

Private Sub Button_Termine_Click()
    FormularBereich = "Termine"
    
    If Me.Haken_Kalender.Value = 0 Then
        If Me.Haken_geloeschte_Termine.Value = 0 Then
            Me.Termine.Visible = True
        Else
            Me.Termine_geloescht.Visible = True
        End If
        Me.Kalender.Visible = False
        Me.Haken_geloeschte_Termine.Enabled = True
    Else
        Me.Termine.Visible = False
        Me.Termine_geloescht.Visible = False
        Me.Kalender.Visible = True
        Me.Haken_geloeschte_Termine.Enabled = False
    End If
    If Me.Haken_geloeschte_Termine.Value = 0 Then
        Me.Haken_Kalender.Enabled = True
        Me.Button_Tabellenansicht.Enabled = True
    Else
        Me.Haken_Kalender.Enabled = False
        Me.Button_Tabellenansicht.Enabled = False
    End If
    Me.Gebuehren.Visible = False
    Me.Rechnungen.Visible = False
    Me.Jahresauswahl.Enabled = True
    Me.Button_Termine.FontWeight = 700
    Me.Button_Rechnungen.FontWeight = 400
    Me.Button_Gebuehren.FontWeight = 400
    
    Me.Hinweis_Preistabelle.Visible = False
    
End Sub

Private Sub eMail_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.eMail.Text)) = 0 Then Me.eMail = " "
End Sub

Private Sub Fax_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Fax.Text)) = 0 Then Me.Fax = " "
End Sub

Private Sub Form_AfterUpdate()
    'falls bei nderung der Name1 gendert wurde, das Suchfeld aktualisieren
    Me.Suchfeld.Requery
    
    'weitere Einstellungen vornehmen (Detailtabellen auf eingestelltes Jahr filtern - erzwingen)
    Call Jahresauswahl_Change
    
    'Preisliste auf akt. Kunden einstellen
    Call PreiseNachKategorieFiltern
    
End Sub

Private Sub Form_Current()
    'falls per Navigator der Datensatz gewechselt wird, Suchfeld mit akt. Satz synchronisieren
    Me.Suchfeld.DefaultValue = Me.lfd_Nr.Value
    'aktuelle Kundennr. merken
    AktKunde = Me.lfd_Nr.Value
    
    'auf Dummy-Kontakt prfen
    If Me.Kunden_ID.Value = KontaktDummy Then
        Me.Hinweis_DummyKontakt.Visible = True
        If FormularBereich = "Gebuehren" Then Me.Hinweis_Preistabelle.Visible = True
        Me.KontaktOeffnenBild.Visible = False
        Me.Name1.Width = 3345                       '3345 Twips ca. "5.899 cm"
        Me.Gebuehr_indiv.Enabled = False
        Me.MwSt_indiv.Enabled = False
        Me.lfd_Nr_MwSteuer.Enabled = False
        Me.Button_Gebuehren.Enabled = False
        Me.Gebuehren.Enabled = False
    Else
        Me.Hinweis_DummyKontakt.Visible = False
        Me.Hinweis_Preistabelle.Visible = False
        Me.Name1.Width = 3002                       '3002 Twips ca. "5.295 cm"
        Me.KontaktOeffnenBild.Visible = True
        Me.Gebuehr_indiv.Enabled = True
        Me.MwSt_indiv.Enabled = True
        Me.lfd_Nr_MwSteuer.Enabled = True
        Me.Button_Gebuehren.Enabled = True
        Me.Gebuehren.Enabled = True
    End If
    
    'Die Routiene "PreiseNachKategorieFiltern" nur aufrufen, wenn das Formular bereits geffnet ist,
    '(unter "Form_Open" wird explizit der Bereich "Kunden" eingestellt)
    'Wrde das Formular mit dem Bereich/Fokus auf die Gebhrentabelle (Preise) geffnet werden, wrend der
    'erste (Dummy-)Datensatz den Haken bei "PreisJeKategorie_JaNein" gesetzt hat, wrde eine Anweisung in der
    'Routine [ Me.Gebuehren.Form.Filter = "([lfd_Nr_Kunde]=" & AktKunde & ") AND ([lfd_Nr_Kategorie]=0)" ]
    'zu einer Exeption im Unterformular "Gebuehren" (Preise) fhren, und zwar an der Stelle:
    '   Private Sub Form_Current()
    '        'merken fr Bearbeitung
    '       AktGebuehr_allg = Me.lfd_Nr.Value
    '   End Sub
    'Siehe auch Kommentar in "Form_Open"
    If FormularBereich = "Gebuehren" Then
        'Preisliste auf akt. Kunden einstellen
        Call PreiseNachKategorieFiltern
    End If
    
    'Me.KontaktOeffnenBild.HyperlinkAddress = "outlook:" & Me.Kunden_ID
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Aktuelles Formular fr Preiseingabe merken
    FormularName = "Kunden"
    
    'Beim ffnen den Formularbereich zwingend auf "Termine" einstellen, damit in der anschlieend
    'ausgefhrten Routine "Form_Current" NICHT die Routine "PreisNachKategorieFiltern" aufgerufen wird,
    'die wegen einer dortigen Anweisung [ Me.Gebuehren.Form.Filter = "([lfd_Nr_Kunde]=" & AktKunde & ") AND ([lfd_Nr_Kategorie]=0)" ]
    'beim ffnen des Formulares zu einer Exeption im Unterformular "Gebuehren" (Preise) fhren wrde,
    'und zwar an der Stelle:
    '   Private Sub Form_Current()
    '        'merken fr Bearbeitung
    '       AktGebuehr_allg = Me.lfd_Nr.Value
    '   End Sub
    'siehe auch Kommentar in "Form_Current"
    FormularBereich = "Termine"
    
    'Datensatz vor Aktualisierung anzeigen
    'Me.Suchfeld.DefaultValue = KundenNrIntern
    Me.Suchfeld.DefaultValue = AktKunde
    Suchfeld_AfterUpdate
    'Bereich vor Aktualisierung einstellen
    If FormularBereich = "Gebuehren" Then Button_Gebuehren_Click
    If FormularBereich = "Rechnungen" Then Button_Rechnungen_Click
    If FormularBereich = "Termine" Then Button_Termine_Click
    'Jahr einstellen
    Me.Jahresauswahl.DefaultValue = Year(Now())
    If Month(Now()) = 1 Then
        Me.Jahresauswahl.DefaultValue = Year(Now()) - 1
    End If
    Me.Jahresauswahl.RowSource = "SELECT DISTINCTROW [Abf_Term_SuDauerJahr].[S_Jahr] FROM [Abf_Term_SuDauerJahr] ORDER BY  [Abf_Term_SuDauerJahr].[S_Jahr] DESC;"
    'Sortierreihenfolge des Formulares auf Name1 aufsteigend stellen
    Me.OrderByOn = False
    Me.OrderBy = "Kunden.Name1"
    Me.OrderByOn = True
    'weitere Einstellungen vornehmen
    Jahresauswahl_Change
    'aktuelle Kundennummer merken fr Datensatznavigator
    KundeAlt = AktKunde
    
    'Kategorieliste fr Preise nach Kategorie auf den ersten Eintrag der Liste einstellen
    Set dbs = CurrentDb
    'Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien WHERE [Kategorie_ID] <> '0123456789DUMMY9876543210' ORDER BY [Name1]")
    Set rst = dbs.OpenRecordset("SELECT * FROM Kategorien ORDER BY [Name1]")
    If rst.RecordCount > 0 Then
        rst.MoveLast                'Auffllen
        rst.MoveFirst
        Me.Kategorien_direkt.DefaultValue = rst!lfd_Nr
        Me.Kategorien_direkt.Requery
        AktKategorie = rst!lfd_Nr
    Else
        AktKategorie = 0
    End If
    rst.Close
    
    
End Sub

Private Sub Form_Timer()
    'Prfen, ob der Datensatz per Datensatznavigator weiterbewegt wurde und
    'Unter-Formulare erneut auf angezeigtes Jahr filtern.
    '(Ist an dieser Stelle notwendig, da das Einfgen der Procedure "Jahresauswahl_Change" in
    'die "Current"-Eigenschaft des Haupt-Formulares zu einem Fehler fhrt.)
    If KundeAlt <> AktKunde Then
        Call Jahresauswahl_Change
        KundeAlt = AktKunde
    End If
End Sub

Private Sub Gebuehr_indiv_Click()
    If Me.Gebuehr_indiv.Value = True Then
        Call Button_Gebuehren_Click
    End If
End Sub

Private Sub Haken_geloeschte_Termine_AfterUpdate()
    If Me.Haken_geloeschte_Termine.Value = 0 Then
        Me.Haken_Kalender.Enabled = True
        Me.Haken_geloeschte_Termine_Bez.ForeColor = 0
        Me.Termine.Form.Visible = True
        Me.Termine_geloescht.Form.Visible = False
        Me.Button_Tabellenansicht.Enabled = True
    Else
        Me.Haken_Kalender.Enabled = False
        Me.Haken_geloeschte_Termine_Bez.ForeColor = 255
        Me.Termine.Form.Visible = False
        Me.Termine_geloescht.Form.Visible = True
        Me.Button_Tabellenansicht.Enabled = False
    End If
    
    'Tabellen erneut auf das ausgewhlte Jahr filtern
    Call Jahresauswahl_Change
End Sub

Private Sub Haken_Kalender_AfterUpdate()
    Call Button_Termine_Click
End Sub

Private Sub Jahresauswahl_AfterUpdate()
    Jahresauswahl_Change
End Sub

Private Sub Jahresauswahl_Change()
    Dim dbs As Database
    Dim qdf As QueryDef
    Dim strAbfrage As String
    
    'Filter fr Termine setzen
    Me.Termine.Form.FilterOn = False
    Me.Termine.Form.Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
        " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & ")))"
    Me.Termine.Form.FilterOn = True
    Me.Termine.Form.Requery
    Me.Termine_geloescht.Form.FilterOn = False
    Me.Termine_geloescht.Form.Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
        " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & ")))"
    Me.Termine_geloescht.Form.FilterOn = True
    Me.Termine_geloescht.Form.Requery
    'Filter fr Kalender setzen
    '    Me.Kalender.Form.FilterOn = False
    '    Me.Kalender.Form.Filter = "[Jahr]=" & Me.Jahresauswahl.Value
    '    Me.Kalender.Form.FilterOn = True
        'Kunden-Nr. und Jahr in den SQL-Text der Abfrage einbauen...
        strAbfrage = "SELECT Min(Termine_Kalender.Monat) AS Monat, Sum(Termine_Kalender.T01) AS T01, Sum(Termine_Kalender.T02) AS T02, " _
                    & "Sum(Termine_Kalender.T03) AS T03, Sum(Termine_Kalender.T04) AS T04, Sum(Termine_Kalender.T05) AS T05, Sum(Termine_Kalender.T06) AS T06, " _
                    & "Sum(Termine_Kalender.T07) AS T07, Sum(Termine_Kalender.T08) AS T08, Sum(Termine_Kalender.T09) AS T09, Sum(Termine_Kalender.T10) AS T10, " _
                    & "Sum(Termine_Kalender.T11) AS T11, Sum(Termine_Kalender.T12) AS T12, Sum(Termine_Kalender.T13) AS T13, Sum(Termine_Kalender.T14) AS T14, " _
                    & "Sum(Termine_Kalender.T15) AS T15, Sum(Termine_Kalender.T16) AS T16, Sum(Termine_Kalender.T17) AS T17, Sum(Termine_Kalender.T18) AS T18, " _
                    & "Sum(Termine_Kalender.T19) AS T19, Sum(Termine_Kalender.T20) AS T20, Sum(Termine_Kalender.T21) AS T21, Sum(Termine_Kalender.T22) AS T22, " _
                    & "Sum(Termine_Kalender.T23) AS T23, Sum(Termine_Kalender.T24) AS T24, Sum(Termine_Kalender.T25) AS T25, Sum(Termine_Kalender.T26) AS T26, " _
                    & "Sum(Termine_Kalender.T27) AS T27, Sum(Termine_Kalender.T28) AS T28, Sum(Termine_Kalender.T29) AS T29, Sum(Termine_Kalender.T30) AS T30, " _
                    & "Sum(Termine_Kalender.T31) AS T31 " _
                    & "FROM Termine_Kalender " _
                    & "WHERE (((Termine_Kalender.lfd_Nr_Kunde) = " _
                    & Me.lfd_Nr.Value _
                    & " OR (Termine_Kalender.lfd_Nr_Kunde) = -1) AND ((Termine_Kalender.Jahr) = " _
                    & Me.Jahresauswahl.Value _
                    & " OR (Termine_Kalender.Jahr) = -1)) " _
                    & "GROUP BY Termine_Kalender.Monat_Nr " _
                    & "ORDER BY Termine_Kalender.Monat_Nr;"
        '...und Abfrage neu erstellen
        Set dbs = CurrentDb
        dbs.QueryDefs.Refresh
        On Error Resume Next                        'Fehlermeldung bei fehlender Abfrage ignorieren
        dbs.QueryDefs.Delete "Abf_KalenderRaster"
        Set qdf = dbs.CreateQueryDef("Abf_KalenderRaster", strAbfrage)
        dbs.QueryDefs.Refresh
    Me.Kalender.Form.RecordSource = "Abf_KalenderRaster"  'muss erneut gesetzt werden, da sonst .Requery ohne Wirkung bleibt
    Me.Kalender.Form.Requery
    'Filter fr Rechnungsliste setzen
    Me.Rechnungen.Form.FilterOn = False
    Me.Rechnungen.Form.Filter = "[Re_Jahr]=" & Me.Jahresauswahl.Value
    Me.Rechnungen.Form.FilterOn = True
    Me.Rechnungen.Form.Requery
    
    'Sortierreihenfolgen in den Unterformularen setzen
    Me.Termine.Form.OrderByOn = False
    Me.Termine.Form.OrderBy = "Termine.Start"
    Me.Termine.Form.OrderByOn = True
    Me.Termine_geloescht.Form.OrderByOn = False
    Me.Termine_geloescht.Form.OrderBy = "[Termine_geloescht].[Start]"
    Me.Termine_geloescht.Form.OrderByOn = True
    Me.Rechnungen.Form.OrderByOn = False
    Me.Rechnungen.Form.OrderBy = "[Rechnungen].[Re_Nr]"
    Me.Rechnungen.Form.OrderByOn = True
    Me.Gebuehren.Form.OrderByOn = False
    Me.Gebuehren.Form.OrderBy = "[Preise].[gilt_ab] DESC"
    Me.Gebuehren.Form.OrderByOn = True
    'Button zum Aktivieren von Terminen mit negativem Saldo deaktivieren
    TerminAktivieren.Visible = False
End Sub

Private Sub PreiseNachKategorieFiltern()
    
    ' ====>>>  Preislisten in der Kundenmaske IMMER auf akt. Kunden einstellen:
    '==========================================================================
    
    'Filter aktivieren
    Me.Gebuehren.Form.FilterOn = True
    'Hakenfeld auswerten
    If Me.Kasten_PreisJeKategorieJaNein.Value = False Then
        'Preisliste ohne Kategorien
        ReKundePreisJeKategorie = False
        'Sonderfall: Dummy-Kontakt (=ZENTALE Preisliste)
        If AktKunde = SatzKontaktDummy Then
            ''' RePreisJeKategorie = False  <- darf hier NICHT gesetzt werden, nur in den Einstellungen!
        End If
        Me.Gebuehren.Form.Filter = "([lfd_Nr_Kunde]=" & AktKunde & ") AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
    Else
        'Preisliste mit Kategorien und diese Filtern
        ReKundePreisJeKategorie = True
        'Sonderfall: Dummy-Kontakt (=ZENTALE Preisliste)
        If AktKunde = SatzKontaktDummy Then
            ''' RePreisJeKategorie = True  <- darf hier NICHT gesetzt werden, nur in den Einstellungen!
        End If
        If Not IsNull(Me.Kategorien_direkt.Value) Then
            AktKategorie = Me.Kategorien_direkt.Value
        Else
            AktKategorie = 0
        End If
'MsgBox AktKategorie
        If AktKategorie = 0 Then
            'Wenn Auswahl keinen Wert enthlt, 0 bergeben
            Me.Gebuehren.Form.Filter = "([lfd_Nr_Kunde]=" & AktKunde & ") AND ([lfd_Nr_Kategorie]=0)"
        Else
            Me.Gebuehren.Form.Filter = "([lfd_Nr_Kunde]=" & AktKunde & ") AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        End If
    End If
    'Tabelle aktualisieren
    Me.Gebuehren.Form.FilterOn = True
    Me.Gebuehren.Form.Requery
End Sub

Private Sub Kasten_PreisJeKategorieJaNein_AfterUpdate()
    Call PreiseNachKategorieFiltern
End Sub

Private Sub Kategorien_direkt_Change()
    Call PreiseNachKategorieFiltern
End Sub

Private Sub KontaktOeffnenBild_Click()
    OutlookElementOeffnen Me.Kunden_ID
End Sub

Private Sub Land_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Land.Text)) = 0 Then Me.Land = " "
End Sub

Private Sub MwSt_indiv_Click()
    If Me.MwSt_indiv.Value = True Then
        Me.lfd_Nr_MwSteuer.SetFocus
        Me.lfd_Nr_MwSteuer.Dropdown
    End If
End Sub

Private Sub Name1_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Name1.Text)) = 0 Then Me.Name1 = " "
End Sub

Private Sub Name2_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Name2.Text)) = 0 Then Me.Name2 = " "
End Sub

Private Sub Name3_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Name3.Text)) = 0 Then Me.Name3 = " "
End Sub

Private Sub Ort_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Ort.Text)) = 0 Then Me.Ort = " "
End Sub

Private Sub PLZ_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.PLZ.Text)) = 0 Then Me.PLZ = " "
End Sub

Private Sub Strasse_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Strasse.Text)) = 0 Then Me.Strasse = " "
End Sub

Private Sub Suchfeld_AfterUpdate()
    ' Den mit dem Steuerelement bereinstimmenden Datensatz suchen.
    On Error Resume Next                            'falls Kundentabelle leer ist
    Me.RecordsetClone.FindFirst "[lfd_Nr] = " & Me![Suchfeld]
    Me.Bookmark = Me.RecordsetClone.Bookmark
End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Telefon1_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Telefon1.Text)) = 0 Then Me.Telefon1 = " "
End Sub

Private Sub Telefon2_LostFocus()
    'Verhinderung des Feldinhaltes "Null", da dies spter bei Abfragen zu Fehlern fhrt
    If Len(Trim(Me.Telefon2.Text)) = 0 Then Me.Telefon2 = " "
End Sub

Private Sub Terminliste_drucken_Click()
On Error GoTo Err_Terminliste_drucken_Click
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    Dim dbs As Database, rst As Recordset

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    Select Case FormularBereich
        Case "Gebuehren"
            BerichteUeberschrift = ""
            BerichteFilter = ""
            BerichteJahreswahl = ""
        
            BerichteFilter = "[lfd_Nr]=" & Me.lfd_Nr.Value
        
            'Formular anzeigen
            DoCmd.OpenReport "Kunden_Gebuehren_Hauptformular", acPreview
            
            'Gebhrentabelle ffnen
            Set dbs = CurrentDb
            Set rst = Me.Gebuehren.Form.RecordsetClone
            'wenn kein Datensatz vorhanden, dann Hinweis auf dem Bericht anzeigen...
            If (rst.RecordCount = 0) Then
                Reports.Item("Kunden_Gebuehren_Hauptformular").Controls.Item("HinweisKeineGebuehr").Caption = "Keine individuellen Preise vorhanden."
            End If
            'Tabelle schliessen
            rst.Close
            Set dbs = Nothing

        Case "Rechnungen"
            BerichteUeberschrift = ""
            BerichteFilter = ""
            BerichteJahreswahl = ""
        
            BerichteUeberschrift = Me.Jahresauswahl.Value
            BerichteFilter = "[lfd_Nr]=" & Me.lfd_Nr.Value
            BerichteJahreswahl = Me.Jahresauswahl.Value
        
            'Formular anzeigen
            DoCmd.OpenReport "Kunden_Rechnungen_Hauptformular", acPreview

        Case Else           'da "Termine" am Anfang nicht explizit zugewiesen wird, aber angezeigt werden
            BerichteUeberschrift = ""
            BerichteFilter = ""
            BerichteJahreswahl = ""
        
            BerichteUeberschrift = Me.Jahresauswahl.Value
            BerichteFilter = "[lfd_Nr]=" & Me.lfd_Nr.Value
            BerichteJahreswahl = Me.Jahresauswahl.Value
            
            'Formular anzeigen
            DoCmd.OpenReport "Kunden_Termine_Hauptformular", acPreview
        
    End Select
    
    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow


Exit_Terminliste_drucken_Click:
    Exit Sub

Err_Terminliste_drucken_Click:
    MsgBox err.Description
    Resume Exit_Terminliste_drucken_Click

End Sub

Private Sub TerminAktivieren_Click()
On Error GoTo Err_TerminAktivieren_Click

    'Achtung: Prfen, ob Termin vor dem Abschlussjahr liegt, das in den Einstellungen
    '         hinterlegt wurde. Dann darf der Termin nicht verschoben werden.
    
    



Exit_TerminAktivieren_Click:
    Exit Sub

Err_TerminAktivieren_Click:
    MsgBox err.Description
    Resume Exit_TerminAktivieren_Click
    
End Sub

Sub Kombinationsfeld69_AfterUpdate()
    ' Den mit dem Steuerelement bereinstimmenden Datensatz suchen.
    Me.RecordsetClone.FindFirst "[lfd_Nr] = " & Me![Kombinationsfeld69]
    Me.Bookmark = Me.RecordsetClone.Bookmark
End Sub

Private Sub Button_Tabellenansicht_Click()
On Error GoTo Err_Button_Tabellenansicht_Click
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    Dim dbs As Database, rst As Recordset

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    Select Case FormularBereich
        Case "Gebuehren"
''            BerichteUeberschrift = ""
''            BerichteFilter = ""
''            BerichteJahreswahl = ""
''
''            BerichteFilter = "[lfd_Nr]=" & Me.lfd_Nr.Value
''
''            'Formular anzeigen
''            DoCmd.OpenReport "Kunden_Gebuehren_Hauptformular", acPreview
''
''            'Gebhrentabelle ffnen
''            Set dbs = CurrentDb
''            Set rst = Me.Gebuehren.Form.RecordsetClone
''            'wenn kein Datensatz vorhanden, dann Hinweis auf dem Bericht anzeigen...
''            If (rst.RecordCount = 0) Then
''                Reports.Item("Kunden_Gebuehren_Hauptformular").Controls.Item("HinweisKeineGebuehr").Caption = "Keine individuellen Preise vorhanden."
''            End If
''            'Tabelle schliessen
''            rst.Close
''            Set dbs = Nothing

        Case "Rechnungen"
''            BerichteUeberschrift = ""
''            BerichteFilter = ""
''            BerichteJahreswahl = ""
''
''            BerichteUeberschrift = Me.Jahresauswahl.Value
''            BerichteFilter = "[lfd_Nr]=" & Me.lfd_Nr.Value
''            BerichteJahreswahl = Me.Jahresauswahl.Value
''
''            'Formular anzeigen
''            DoCmd.OpenReport "Kunden_Rechnungen_Hauptformular", acPreview

        Case Else           'da "Termine" am Anfang nicht explizit zugewiesen wird, aber angezeigt werden
            'Formular anzeigen
            DoCmd.OpenForm "Termine_alsTabelle", acFormDS, , , acFormReadOnly, acWindowNormal
            'Filter fr Termine setzen
            Forms.Item("Termine_alsTabelle").FilterOn = False
            Forms.Item("Termine_alsTabelle").Filter = "((([S_Jahr]=" & Me.Jahresauswahl.Value & ") OR ([E_Jahr]=" & Me.Jahresauswahl.Value & "))" & _
                " OR (([S_Jahr]<" & Me.Jahresauswahl.Value & ") AND ([E_Jahr]>" & Me.Jahresauswahl.Value & "))) AND [lfd_Nr_Kunde]=" & AktKunde
            Forms.Item("Termine_alsTabelle").FilterOn = True
            'Sortierreihenfolgen setzen
            Forms.Item("Termine_alsTabelle").OrderByOn = False
            Forms.Item("Termine_alsTabelle").OrderBy = "Termine.Start"
            Forms.Item("Termine_alsTabelle").OrderByOn = True
            Forms.Item("Termine_alsTabelle").Requery
    End Select
    
    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe


Exit_Button_Tabellenansicht_Click:
    Exit Sub

Err_Button_Tabellenansicht_Click:
    MsgBox err.Description
    Resume Exit_Button_Tabellenansicht_Click

End Sub
